;================================================

;================================================
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 
begin
;************************************************
; open file and read in data
;************************************************

;*************************
  geof1  = addfile("/home/user/chensy3/data/zhangyue/WPSV391_2020-03/geo_em.d01.nc","r")
  lat1_sim   = geof1->XLAT_M
  lon1_sim   = geof1->XLONG_M
  lat1=lat1_sim(0,:,0)
  lon1=lon1_sim(0,0,:)

  nday=6
  plot=new(nday,graphic)
  plot_t=new(nday,graphic)
  vector=new(nday,graphic)

loc=wrf_user_ll_to_ij(geof1, (/78,146/), (/25,51/), True)
Xstart=loc(0,0)
Xend=loc(0,1)
Ystart=loc(1,0)
Yend=loc(1,1)
;************************************************
wks = gsn_open_wks("png","6_zoom")     ; open a workstation

;gsn_define_colormap(wks,"BlueDarkRed18")

;========================================


path=" /home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/ETL_data/dust_emission/2020-03/"

filename="wrfout_dustemission_wind10_2020_03_1*.nc"
outfiles=systemfunc("ls " +path+filename)
f=addfiles(outfiles+".nc","r")

ListSetType(f,"join")
var = wrf_user_getvar(f(:),"DE",-1)
printVarSummary(var)

u10_avg = wrf_user_getvar(f(:),"u10",-1)
v10_avg = wrf_user_getvar(f(:),"v10",-1)

    
;=======================================
  res                   = True              ; plot mods desired
  res@Footer = False
  res@InitTime    = False
  res@FieldTitle=""
  res@NoHeaderFooter           = True            ; Switch headers and footers off
 
;============================================

   res@cnFillPalette="WhiteBlueGreenYellowRed"       ;"WhiteYellowOrangeRed"
   res@cnLevelSelectionMode ="ExplicitLevels"
   res@cnLevels=(/0.1,1,5,10,20,30,40,50/)
   res@cnFillColors = (/0,66,82,98,114,146,162,178,194/)

;============================================
  res@cnLineLabelsOn       = False
  res@pmLabelBarWidthF = 0.9
  res@pmLabelBarHeightF=0.3
  res@lbLabelFontHeightF=0.03
  res@lbBoxSeparatorLinesOn=False
  ;res@pmLabelBarOrthogonalPosF=-0.14 

  res@cnFillOn              = True            ; color plot desired
  res@cnLinesOn             = False    
 

  pltres=True
  pltres@PanelPlot = True      ; Indicate these plots are to be paneled.

  map_res = True
  map_res@gsnDraw=False
  map_res@gsnFrame=False
  map_res@mpDataSetName  = "/home/data/data-CSR4/chenyu/mapdata/Earth..4"
  map_res@mpDataBaseVersion="MediumRes"
  map_res@mpOutlineOn = True
  map_res@mpAreaMaskingOn       = True
  ;map_res@mpMaskAreaSpecifiers  = (/"China:states"/)
  ;map_res@mpOutlineSpecifiers = (/"China:states"/)
  map_res@mpNationalLineColor        = "black"
  map_res@mpCountyLineColor      = "black"
  map_res@mpProvincialLineColor  ="black"
  map_res@mpGeophysicalLineColor="black"
  map_res@mpGeophysicalLineThicknessF =2.5;3.5

  map_res@mpNationalLineThicknessF=2.5;3.5
  map_res@tmXBLabelFontHeightF=0.025
  map_res@tmYLLabelFontHeightF=0.025
  map_res@tmBorderThicknessF=6
    ;限制wrfout的输出区域
  map_res@ZoomIn=True
  map_res@Xstart=Xstart
  map_res@Xend=Xend
  map_res@Ystart=Ystart
  map_res@Yend=Yend

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   resb                   = True              ; plot mods desired
   resb@Footer = False
   resb@InitTime    = False
   resb@FieldTitle=""

   resb@NoHeaderFooter           = True            ; Switch headers and footers off

   resb@cnFillPalette="temp_diff_18lev"
  resb@cnLevelSelectionMode ="ExplicitLevels"

   Levels = (/-10,-5,-2,-1.5,-1,-0.7,-0.5,-0.3,-0.1,-0.01,0.01,0.1,0.3,0.5,0.7,1,1.5,2,5,10/);(/-0.3,-0.2,-0.1,-0.05,-0.02,-0.01,0.01,0.02,0.05,0.1,0.15,0.2,0.25,0.3/)
   resb@cnLevels = Levels
   ;resb@cnFillColors = (/3,4,5,6,7,8,0,12,13,14,15,16,17,18,19/)

   resb@cnLineLabelsOn       = False
   resb@pmLabelBarWidthF = 0.9
   resb@pmLabelBarHeightF=0.3

   resb@cnFillOn              = True            ; color plot desired
   resb@cnLinesOn             = False
   resb@lbLabelFontHeightF=0.03
   resb@lbBoxSeparatorLinesOn=False
 ;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::  
  opts = True
  opts@Footer = False
  opts@InitTime    = False
  opts@FieldTitle=""
  opts@gsnDraw          = False    ; Make sure don't draw or frame or,
  opts@gsnFrame         = False    ; maximize, b/c we'll do this later.
  opts@vcRefMagnitudeF  = 5                     ; add a reference vector
  opts@vcRefLengthF     = 0.03                ; what the ref length is
  opts@vcWindBarbLineThicknessF=1.5
  opts@vcWindBarbTickSpacingF=0.2
  opts@vcWindBarbTickLengthF=0.4
  opts@vcGlyphStyle="CurlyVector"           ; turn on curley vectors
  opts@vcLineArrowColor        = "blue"
  opts@vcMinDistanceF =0.04
  opts@vcRefAnnoOn=True      ;hua fengbiao de chicun
  opts@vcRefAnnoString1="5m/s"
  opts@vcRefAnnoFontHeightF=0.025
  ;opts@vcRefAnnoPerimOn=False
  opts@vcRefAnnoString2On=False
  ;opts@vcRefAnnoSide ="Top"  ;Bottom;Right;Left
  ;opts@vcRefAnnoOrthogonalPosF =-0.2
  ;opts@vcLabelFontHeightF=0.01
  opts@vcRefAnnoSide = "Right"
  opts@vcRefAnnoOrthogonalPosF = -0.095 
  opts@vcRefAnnoParallelPosF   = 1.0
  opts@lbLabelFontHeightF=0.03
  ;opts@vcRefAnnoJust ="TopRight"
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  optsb = True
  optsb@Footer = False
  optsb@InitTime    = False
  optsb@FieldTitle=""
  optsb@gsnDraw          = False    ; Make sure don't draw or frame or,
  optsb@gsnFrame         = False    ; maximize, b/c we'll do this later.
  optsb@vcRefMagnitudeF  = 0.01                     ; add a reference vector
  optsb@vcRefLengthF     = 0.03                ; what the ref length is
  optsb@vcWindBarbLineThicknessF=1.5
  optsb@vcWindBarbTickSpacingF=0.2
  optsb@vcWindBarbTickLengthF=0.4
  optsb@vcGlyphStyle="CurlyVector"           ; turn on curley vectors
  optsb@vcLineArrowColor        = "blue"
  optsb@vcMinDistanceF =0.04
  optsb@vcRefAnnoOn=True      ;hua fengbiao de chicun
  optsb@vcRefAnnoString1="0.01m/s"
  optsb@vcRefAnnoFontHeightF=0.03
  optsb@vcRefAnnoPerimOn=False
  optsb@vcRefAnnoString2On=False
  ;optsb@vcRefAnnoSide ="Top"  ;Bottom;Right;Left
  ;optsb@vcRefAnnoOrthogonalPosF =-0.2


  ;optsb@vcRefAnnoJust ="TopRight"
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   plot_t(0)=wrf_contour(geof1,wks,var(0,Ystart:Yend,Xstart:Xend),res)
   vector(0)  = wrf_vector(geof1,wks,u10_avg(0,Ystart:Yend,Xstart:Xend),v10_avg(0,Ystart:Yend,Xstart:Xend),opts)
   plot(0) = wrf_map_overlays(geof1,wks,(/plot_t(0),vector(0)/),pltres,map_res)


;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;

   varb=new((/5,239,289/),float)
   u10_avgb=new((/5,239,289/),float)
   v10_avgb=new((/5,239,289/),float)
   
   do m=1,5
   
   varb(m-1,:,:)=var(m,:,:)-var(0,:,:)    
   u10_avgb(m-1,:,:)=u10_avg(m,:,:)-u10_avg(0,:,:)
   v10_avgb(m-1,:,:)=v10_avg(m,:,:)-v10_avg(0,:,:)
   
   plot_t(m)=wrf_contour(geof1,wks,varb(m-1,Ystart:Yend,Xstart:Xend),resb)
   ;vector(m)  = wrf_vector(geof1,wks,u10_avgb(m-1,:,:),v10_avgb(m-1,:,:),optsb)
   plot(m) = wrf_map_overlays(geof1,wks,(/plot_t(m)/),pltres,map_res);,vector(m)

   end do
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  shp1="/home/user/chensy3/csr4/chenyu/NCL/china/mygeodata/china.shp"
  lnres1        = True
  lnres1@gsLineColor      ="black"
  lnres1@gsLineThicknessF = 2.5;3.5;          ; 2x thickness
  shp_plot1     = gsn_add_shapefile_polylines(wks,plot(0),shp1,lnres1)
  shp_plot2     = gsn_add_shapefile_polylines(wks,plot(1),shp1,lnres1)
  shp_plot3     = gsn_add_shapefile_polylines(wks,plot(2),shp1,lnres1)
  shp_plot4     = gsn_add_shapefile_polylines(wks,plot(3),shp1,lnres1)
  shp_plot5     = gsn_add_shapefile_polylines(wks,plot(4),shp1,lnres1)
  shp_plot6     = gsn_add_shapefile_polylines(wks,plot(5),shp1,lnres1)
  
;=====================TOTAL===================
pres                  = True
pres@gsnMaximize=True

pres@gsnPanelScalePlotIndex	= 0
pres@gsnPanelYWhiteSpacePercent = 0
pres@gsnPanelXWhiteSpacePercent = 0

pres@gsnPanelFigureStrings = (/"(f)"/);,"(b)","(c)","(d)","(e)","(f)"
pres@gsnPanelFigureStringsFontHeightF = 0.035
pres@amOrthogonalPosF    =-0.5
pres@amParallelPosF      =-0.5
pres@amJust = "TopLeft"
gsn_panel(wks,plot(5),(/1,1/),pres)
  
  
print("Game Over")
end
